parms = list(A=matrix(c(1,2/5,4/3,1),2,2), r=c(0.5,0.5),
             K=c(1000,500))
N0 = c(250,500)
t_max = 100
N = N0
t = 0
ts = c(t)
Ns = N

while ( t < t_max )
  {
  # define rates of events
  lambdas = with(parms,c(N[1]*r[1], N[2]*r[2],
    r[1]*N[1]*(N[1]+A[1,2]*N[2])/K[1],
    r[2]*N[2]*(N[2]+A[2,1]*N[1])/K[2]))

  # draw time to next event
  dt = rexp(1,sum(lambdas))
  # draw event type
  i = sample(length(lambdas),1,prob=lambdas)
  if ( i == 1 ) N[1] = N[1] + 1 else
  if ( i == 2 ) N[2] = N[2] + 1 else
  if ( i == 3 ) N[1] = N[1] - 1 else
  if ( i == 4 ) N[2] = N[2] - 1

  t = t + dt
  ts = c(ts,t)
  Ns = rbind(Ns,N)
  }
plot(ts,Ns[,1],col='blue',type='l',xlab='t',ylab='N',
     ylim=range(c(0,Ns)))
lines(ts,Ns[,2],col='red') 
